#include "TKText.h"

TKT::TKT()
{
    couleur = {127, 127, 127};
    dcouleur = {5, 125, 250};
    TTF_Init();
    fground = NULL;
    IMG = NULL;
}

TKT::~TKT()
{
    TTF_Quit();
}

void TKT::setFont(const char *url_police, int size)
{
    police = TTF_OpenFont(url_police, size);
}

void TKT::setPos(int x, int y)
{
    pos.x = x;
    pos.y = y;
}

void TKT::afficher(SDL_Surface *ecran)
{
    SDL_BlitSurface(IMG, NULL, ecran, &pos);
}

void TKT::setColor(int r, int g, int b)
{
    couleur = {r, g, b};
    ecouleur = {r / 4, g / 4, b / 4};
}

void TKT::setText(const char *enter_txt)
{
    sprintf(txt, enter_txt);
    if(IMG)
    	SDL_FreeSurface(IMG);
    IMG = TTF_RenderText_Solid(police, txt, couleur);

    fground = SDL_CreateRGBSurface(SDL_HWSURFACE, IMG->w, IMG->h, 32, 0, 0, 0, 0);
    SDL_FillRect(fground, NULL, SDL_MapRGB(fground->format, ecouleur.r, ecouleur.g, ecouleur.b));
    int i = 0, j = 0;
    SDL_Surface *barre = SDL_CreateRGBSurface(SDL_HWSURFACE, IMG->w, 1, 32, 0, 0, 0, 0);
    SDL_Rect b_pos;
    b_pos.x = 0;
    b_pos.y = 0;
    for(i = 0; i < IMG->h; i ++)
    {
        if(i <= IMG->h / 2)
        {
            SDL_FillRect(barre, NULL, SDL_MapRGB(barre->format, ((i * couleur.r) / (IMG->h / 2)), ((i * couleur.g) / (IMG->h / 2)), ((i * couleur.b) / (IMG->h / 2))));
            b_pos.y = i;
            j = 0;
        }
        else
        {
            SDL_FillRect(barre, NULL, SDL_MapRGB(barre->format, ((j * couleur.r) / (IMG->h / 2)), ((j * couleur.g) / (IMG->h / 2)), ((j * couleur.b) / (IMG->h / 2))));
            j++;
            b_pos.y = -i + (3 * IMG->h) / 2;
        }
        SDL_BlitSurface(barre, NULL, fground, &b_pos);
    }
    SDL_Surface *cal = SDL_CreateRGBSurface(SDL_HWSURFACE, IMG->w, IMG->h, 32, 0, 0, 0, 0);
    SDL_FillRect(cal, NULL, SDL_MapRGB(cal->format, dcouleur.r, dcouleur.g, dcouleur.b));
    b_pos.x = 0;
    b_pos.y = 0;
    SDL_BlitSurface(IMG, NULL, cal, &b_pos);
    SDL_SetColorKey(cal, SDL_SRCCOLORKEY, SDL_MapRGB(cal->format, couleur.r, couleur.g, couleur.b));
    SDL_BlitSurface(cal, NULL, fground, &b_pos);
    SDL_SetColorKey(fground, SDL_SRCCOLORKEY, SDL_MapRGB(fground->format, dcouleur.r, dcouleur.g, dcouleur.b));
    IMG = fground;
    SDL_Surface *cal2 = SDL_CreateRGBSurface(SDL_HWSURFACE, IMG->w, IMG->h, 32, 0, 0, 0, 0);
    SDL_FillRect(cal2, NULL, SDL_MapRGB(cal2->format, 0, 0, 0));
    SDL_SetColorKey(cal2, SDL_SRCCOLORKEY, SDL_MapRGB(cal2->format, 0, 0, 0));
    cal = TTF_RenderText_Solid(police, txt, ecouleur);
    if(IMG->h / 50 >= 1)
    {
        for(i = -(IMG->h / 50); i <= (IMG->h / 50); i ++)
        {
            for(j = -(IMG->h / 50); j <= (IMG->h / 50); j ++)
            {
                b_pos.x = i;
                b_pos.y = j;
                SDL_BlitSurface(cal, NULL, cal2, &b_pos);
            }
        }
    }
    else
    {
        for(i = -1; i <= 1; i ++)
        {
            for(j = -1; j <= 1; j ++)
            {
                b_pos.x = i;
                b_pos.y = j;
                SDL_BlitSurface(cal, NULL, cal2, &b_pos);
            }
        }
    }
    b_pos.x = 0;
    b_pos.y = 0;
    SDL_BlitSurface(fground, NULL, cal2, &b_pos);
    SDL_FreeSurface(fground);
    IMG = cal2;
}
