#include "bouton.h"

Bouton::Bouton()
{
    pos.x = 0;
    pos.y = 0;
    sel = 0;
}
Bouton::Bouton(int x, int y, SDL_Surface *img1, SDL_Surface *img2)
{
    setPos(x, y);
    setImg(img1, img2);
}
void Bouton::setPos(int x, int y)
{
    pos.x = x;
    pos.y = y;
}
void Bouton::setImg(SDL_Surface *img1, SDL_Surface *img2)
{
    normal_img = img1;
    pass_img = img2;
}
void Bouton::afficher(SDL_Surface *ecran)
{
    if(!sel)
    {
        SDL_BlitSurface(normal_img, NULL, ecran, &pos);
    }
    else
    {
        SDL_BlitSurface(pass_img, NULL, ecran, &pos);
    }
}
void Bouton::setDefaultImg()
{
    normal_img = B_IMG_DEFAULT_NORMAL;
    pass_img = B_IMG_DEFAULT_PASS;
}
void Bouton::addText(const char *texte)
{
    btext.setFont("media/font.ttf", 25);
    btext.setPos(15, 25);
    btext.setColor(127, 127, 255);
    btext.setText(texte);
    btext.afficher(normal_img);
    btext.afficher(pass_img);
}
int Bouton::checkIn(int x, int y)
{
    if(((x > pos.x)&&(y > pos.y))&&((x < (pos.x + normal_img->w))&&(y < (pos.y + normal_img->h))))
    {
        sel = 1;
    }
    else
    {
        sel = 0;
    }
    return sel;
}
void Bouton::setSel()
{
    sel = 1;
}

