#include "image.h"

Img::Img()
{
    img = NULL;
    pos.x = 0;
    pos.y = 0;
}

void Img::set(SDL_Surface *m_img, int x, int y)
{
    img = m_img;
    pos.x = x;
    pos.y = y;
}

void Img::set_img(SDL_Surface *m_img)
{
    img = m_img;
}

void Img::set_pos(int x, int y)
{
    pos.x = x;
    pos.y = y;
}

void Img::afficher(SDL_Surface *ecran)
{
    SDL_BlitSurface(img, NULL, ecran, &pos);
}

void Img::colorkey(int r, int g, int b)
{
    SDL_SetColorKey(img, SDL_SRCCOLORKEY, SDL_MapRGB(img->format, r, g, b));
}

int Img::give_pos(int cor)
{
    switch(cor)
    {
        case POSX:
        return pos.x;
        break;
        case POSY:
        return pos.y;
        break;
    }
}

SDL_Surface* Img::give_img()
{
    return img;
}
