#include "menu.h"

Menu::Menu()
{
    fond.set(SDL_LoadBMP("media/img/menu/titre.bmp"), 0, 0);
    cont = 1;
    Gcont = 1;
    for(int i = 0; i < 4; i ++)
    {
        bout[i].setImg(SDL_LoadBMP("media/img/num/texte.bmp"), SDL_LoadBMP("media/img/num/texte2.bmp"));
        bout[i].setPos(500, 75 + (i * 125));
    }
    bout[Bcry].addText("Crypter");
    bout[Bdecry].addText("Décrypter");
    bout[Bcle].addText("Definir clé");
    bout[Bid].addText("Changer son code");
}

int Menu::use(SDL_Surface *ecran, SDL_Event event)
{
    intro(ecran);
    while(cont)
    {
        SDL_WaitEvent(&event);
        switch(event.type)
        {
            case SDL_QUIT:
            cont = 0;
            Gcont = 0;
            break;
            case SDL_KEYDOWN:
            switch(event.key.keysym.sym)
            {
                case SDLK_ESCAPE:
                cont = 0;
                Gcont = 0;
                break;
            }
            break;
            case SDL_MOUSEMOTION:
            for(int i = 0; i < 4; i ++)
            {
                bout[i].checkIn(event.motion.x, event.motion.y);
            }
            break;
            case SDL_MOUSEBUTTONDOWN:
            if(event.button.button == SDL_BUTTON_LEFT)
            {
                if(bout[Bcry].checkIn(event.button.x, event.button.y))
                {
                    cry.encry(ecran);
                }
                else if(bout[Bdecry].checkIn(event.button.x, event.button.y))
                {
                    cry.decry(ecran);
                }
                else if(bout[Bcle].checkIn(event.button.x, event.button.y))
                {
                    cry.setKey(ecran);
                }
                else if(bout[Bid].checkIn(event.button.x, event.button.y))
                {
                    code.newcode(ecran, event);
                    intro(ecran);
                }
            }
            break;
        }
        fond.afficher(ecran);
        for(int i = 0; i < 4; i ++)
        {
            bout[i].afficher(ecran);
        }
        SDL_Flip(ecran);
    }

    return Gcont;
}

void Menu::intro(SDL_Surface *ecran)
{
    for(int i = 0; i < 4; i ++)
    {
        bout[i].setPos(800, 0 + (i * 125));
    }
    for(int i = 0; i < 26; i ++)
    {
        fond.afficher(ecran);
        for(int j = 0; j < 4; j ++)
        {
            bout[j].setPos(800 - (i * 12), (i * 3) + (j * 125));
            bout[j].afficher(ecran);
        }
        SDL_Flip(ecran);
        SDL_Delay(25);
    }
}
